proc generic:list_index_to_list {values index} {
	
	# find index
	set final ""
	foreach elem $values {
		lappend final [lindex $elem $index]
	}
	return $final
}



# check a string for wierd characters and leading 0 in a interger , and return it corrected
proc generic:check_num {string} {
	set length [string length $string]
	set count 0
	set new ""
	
	while {$count < $length} {
		set cur [string range $string $count $count]
		if {[string match {[0-9]} $cur] == 1} {
			append new $cur
		}
		incr count
	}
	
	while {[string range $new 0 0] == 0} {
		set new [string range $new 1 end]
	}
	
	if {![string length $new]} {
		set new 0
	}
	
	return [string range $new 0 11]
}


proc generic:rate_to_dec2 {rate} {
	if {$rate == ""} {
		return 0
	} elseif {$rate == "0"} {
		return 0
	} elseif {[string length $rate] == 1} {
		return 0.0$rate
	} elseif {[string length $rate] == 2} {
		return 0.$rate
	} else {
		return "[string range $rate 0 [expr {[string length $rate]-3}]].[string range $rate [expr {[string length $rate]-2}] end]"
	} 
}

proc generic:rate_to_dec {rate} {
	
	set ret [generic:rate_to_dec2 $rate]
	set tmp [split $ret .]
	if {[string match "*0" [lindex $tmp 1]]} {
		return "[lindex $tmp 0].[string index [lindex $tmp 1] 0]"
	}
	return $ret	
}

proc generic:add {int1 int2} {
	if {[lindex $int1 0] == "f"} {
		set int1 [expr {100.0 * [lindex $int1 1]}]
	}
	if {[lindex $int2 0] == "f"} {
		set int2 [expr {100.0 * [lindex $int2 1]}]
	}
	return [expr {round($int1 + $int2)}]
} 	 

proc generic:sub {int1 int2} { 	 
	if {[lindex $int1 0] == "f"} {
		set int1 [expr {100.0 * [lindex $int1 1]}]
	}
	if {[lindex $int2 0] == "f"} {
		set int2 [expr {100.0 * [lindex $int2 1]}]
	}
	return [expr {round($int1 - $int2)}]
} 	 

proc generic:mul {int1 int2} {
	if {[lindex $int1 0] == "f"} {
		set int1 [expr {100.0 * [lindex $int1 1]}]
	}
	if {[lindex $int2 0] == "f"} {
		set int2 [expr {100.0 * [lindex $int2 1]}]
	}
	return [expr {round($int1 * $int2)}]
} 	 

proc generic:div {int1 int2} {
	if {[lindex $int1 0] == "f"} {
		set int1 [expr {100.0 * [lindex $int1 1]}]
	}
	if {[lindex $int2 0] == "f"} {
		set int2 [expr {100.0 * [lindex $int2 1]}]
	}
	return [expr {round(double($int1) / $int2)}]
}

#proc generic:add {int1 int2} {
#	if {[catch {set tmp [expr {round([back_add $int1 $int2])}]}]} {
#		set tmp [back_add $int1 $int2]
#		return [string range $tmp 0 [expr {[string first . $tmp]-1}]]
#	} else {
#		return $tmp
#	}
#}
#
#proc generic:sub {int1 int2} {
#	if {[catch {set tmp [expr {round([back_sub $int1 $int2])}]}]} {
#		set tmp [back_sub $int1 $int2]
#		return [string range $tmp 0 [expr {[string first . $tmp]-1}]]
#	} else {
#		return $tmp
#	}
#}
#
#proc generic:mul {int1 int2} {
#	if {[catch {set tmp [expr {round([back_mul $int1 $int2])}]}]} {
#		set tmp [back_mul $int1 $int2]
#		return [string range $tmp 0 [expr {[string first . $tmp]-1}]]
#	} else {
#		return $tmp
#	}
#}
#
#proc generic:div {int1 int2} {
#	if {[catch {set tmp [expr {round([back_div $int1 $int2])}]}]} {
#		set tmp [back_div $int1 $int2]
#		return [string range $tmp 0 [expr {[string first . $tmp]-1}]]
#	} else {
#		return $tmp
#	}
#}



proc generic:calc_disc {disc sell} {
	if {$disc == "" || $sell == ""} {
		return 0
	}
	if {[lindex $sell 0] == "f"} {
		set sell [expr {100.0 * [lindex $sell 1]}]
	}
	return [expr {round($disc / 100.0 * $sell)}]
}

# NOTE: this old proc cannot handle discounts outside the (0 <= x <= 100) interval
proc generic:calc_disc_old {disc sell} {
	if {$disc == "0" || $disc == "0.0"} {
		return 0
	}

	if {$disc == 100 || $disc == 100.0} {
		return $sell
	}

	if {[string match "*.*" $disc]} {
		if {$disc > 0 && $disc < 10} {
			set tmp [generic:mul $sell 0.0[generic:check_num $disc]]
		} else {
			set tmp [generic:mul $sell 0.[generic:check_num $disc]]
		}
	} else {
		if {$disc > 0 && $disc < 10} {
			set tmp [generic:mul $sell 0.0$disc]
		} else {
			set tmp [generic:mul $sell 0.$disc]
		}
	}
	
	return $tmp
}




# get a random click embedded in the date with chars of "id" infront
set tmp_click -999
proc generic:click {} {
	set click [expr {abs([clock clicks])}]
	while {$::tmp_click == "$click"} {
		after 10
		set click [expr {abs([clock clicks])}]
	}
	set ::tmp_click $click
	
	while {[string length $click] < 10} {
		set click ${click}0
	}
	set click [string range $click 0 9]
	return id[clock format [clock seconds] -format %Y%m%d%H%M%S]$click
}

proc generic:newline_to_cr {value} {
	return [string map {\t " "} $value]
	return [string map {\n <CR>} $value]
}




proc generic:id_to_yyyymmdd {id} {
	return "[string range $id 2 5]-[string range $id 6 7]-[string range $id 8 9]"
}



proc generic:id_to_yyyymmddhhmm {id} {
	return "[string range $id 2 5]-[string range $id 6 7]-[string range $id 8 9]-[string range $id 10 13]"
}


proc generic:get_opt_arg {args_list arg_name default_value} {
	foreach {key value} $args_list {
		if {$key == $arg_name || $key == "-$arg_name"} {
			return $value
		}
	}
	return $default_value
}


proc generic:string_replace {the_string rep_this rep_with} {
	regsub -all $rep_this $the_string $rep_with the_string
	return $the_string
}

proc generic:string_strip_illegal {the_string} {
	regsub -all {[\s\-\]\[$^?+*()|\\%&#]} $the_string "" the_string
	return $the_string
}

proc generic:intday_to_date_format {intday} {
	
	set seconds [generic:intday_to_clockseconds $intday]
	set id id[clock format $seconds -format {%Y%m%d%H}]
	if {$::DATE_SYSTEM == 0} {
		return "[string range $id 2 5]-[string range $id 6 7]-[string range $id 8 9]"
	} elseif {$::DATE_SYSTEM == 1} {
		return "[string range $id 8 9]-[string range $id 6 7]-[string range $id 2 5]"
	} elseif {$::DATE_SYSTEM == 2} {
		return "[string range $id 4 5]-[string range $id 6 7]-[string range $id 8 9]"
	} elseif {$::DATE_SYSTEM == 3} {
		return "[string range $id 8 9]-[string range $id 6 7]-[string range $id 4 5]"
	} elseif {$::DATE_SYSTEM == 4} {
		return "[string range $id 6 7]-[string range $id 8 9]-[string range $id 4 5]"
	} elseif {$::DATE_SYSTEM == 5} {
		return "[string range $id 8 9].[string range $id 6 7].[string range $id 2 5]"
	}
}

proc generic:intday_to_clockseconds {intday {timezone {}}} {
	if {![string is integer $intday]} {
		return $intday
	}
	
	if {$intday == ""} {
	  return ""
	}
	
	set date [lindex $::INTDAY_TO_DATE_LIST $intday]
	
	if {$date == ""} {
		return ""
	}
	
	if {$timezone != ""} {
		return [clock scan "[lindex $date 0]-[lindex $date 1]-[lindex $date 2]" -timezone $timezone]
	} else {
		return [clock scan "[lindex $date 0]-[lindex $date 1]-[lindex $date 2]"]
	}
}

proc generic:inttime_to_time {int_time {ampm_mode ""} {day_start {}} {allow_over_24_hour 0}} {	
	
	if {$day_start == ""} {
		set day_start $::DAY_START
	}

	set hrs [expr {int($int_time + $day_start)}]
	if {!$allow_over_24_hour} {
		if {$hrs > 23} {
			set hrs [expr {$hrs-24}]
		}
	}
	if {[string length $hrs] == 1} {
		set hrs 0${hrs}
	}
	
	#set min [expr {int(($int_time - int($int_time))*60)}]
	
	set min [expr {round(($int_time - int($int_time))*60)}]
	
	if {[string length $min] == 1} {
		set min 0${min}
	}
	
	if {$ampm_mode == ""} {
		set ampm_mode $::USE_AMPM
	}
	
	if {$ampm_mode == 0} {
		return "$hrs:$min"
	} elseif {$ampm_mode == 1} {
		set extra "pm"
		if {$int_time < (12 - $day_start) || $int_time >= (24 - $day_start)} {
			set extra "am"
		}
		
		if {[string index $hrs 0] == "0"} {
			set hrs [string index $hrs 1]
		}
		if {$hrs > 12} {
			set hrs [expr {$hrs-12}]
		}
		
		return "$hrs:${min} $extra"
		
	} elseif {$ampm_mode == 2} {
		if {[string index $hrs 0] == "0"} {
			set hrs [string index $hrs 1]
		}
		if {$hrs > 12} {
			set hrs [expr {$hrs-12}]
		}
		
		return "$hrs:$min"
		
	}
}

